---
layout:     post
title:      「体能训练理论」之功能性
subtitle:   「健身先健脑」科学的运动需要科学的运动理论
date:       2017-07-10
author:     BY
header-img: img/post-bg-mma-3.jpg
catalog: true
tags:
    - 健身
    - 生活
---


## 引言

体能训练是一种开源的程序它所依仗的并不是固有的方法手段，而是能够贯穿始终的逻辑，它是一种指导实践的思维方式，我们管它叫“体能思路”。

体能思路有两个方向，一个是原点，一个是过程。所谓原点我们认为是人体的本质属性，比如之前我们分享的五大运动素质以及动力链理论。所谓过程是我们分析问题实现目的的思考方向以及逻辑，它主要体现在接下来要跟大家分享的功能性原则和金字塔。

今天先来说功能性原则。

## 功能性


我们所说的功能性是一种解决问题的思维方式，而功能性训练则定义了一种多关节参与，多平面运动的复杂练习。功能性训练是具体的，比较好理解，我就不赘述了，也不评价其优劣，因为在“功能性”的思维方式下，只存在目标之下的合适与否。

### 什么是功能性？

我们把它定义为目标导向下的效率，所以它是一种程度的体现。如果一个练习与目标的相关性强，那么我们认为它具备较强的功能意义；而如果一个练习与它的目标背道而驰，那么我们就认为它缺乏功能意义。

举个例子，对于偏瘫患者来说，一个手指的屈伸就已经具备非常强的功能意义了，而对于一个马拉松爱好者来说，静蹲的价值可能并不是想象中那么高。

一般来说，在思考功能性问题的时候我习惯从以下三个方面入手：**肌肉的生理适应** 、**动作模式** 和 **专项需求**。

#### 1. 肌肉的生理适应

其实练肌肉谁都会，是一个相对好入手的技能，但是当你给这个行为赋予体能训练使命的时候就需要思考一些问题，比如说你现在练习所发展的东东真的是你实际运动中所需要的东东么？

![](https://ws1.sinaimg.cn/large/006tKfTcgy1fhg24pm22dj30e709474v.jpg)

我们都知道肌肉的生理收缩模式可以简单的分为向心收缩，离心收缩和静力收缩。现在的研究表明，这三种收缩模式的练习所产生的适应性提高存在显著的特异性。也就是说我向心练习所发展的能力只在向心运动中表现最好，在离心和静力中都不佳。同样，离心收缩也只能获得最好的离心能力收益。而静力就更变态，其训练最佳效果仅仅体现在所锻炼的关节角度下，换一个角度能够迁移的效果有可能都不到一半儿。这样看来，你的训练是不是并没有达到你想要的效果呢？

举个例子：

![](https://ws1.sinaimg.cn/large/006tKfTcgy1fhg251pmatj30go0b5q5d.jpg)

为什么静蹲对于跑步爱好者来说可能并没有那么理想？因为膝关节股四头肌在跑步中以离心缓冲为主，而且角度在伸膝末端的30°左右，而静蹲却是在屈曲90°左右的角度下呆着不动……着不动……不动……动……

除此之外，需要考虑的问题还很多，比如说发力模式，是加速？减速？还是匀速？再比如关节活动角度上发力点的位置，是伸展末端发力？屈曲极限发力？还是在屈伸过程中的某一点发力？阻力加在哪里，就会在哪里产生最好的适应，那么功能的意义就体现在这里。

#### 2. 动作模式

动作模式是动作程序的体现，而基础动作模式是诸多复杂动作模式共性的抽象体现，并且基础动作模式一定是符合解剖结构和生物力学特点的，说白了也就是我们人体被设计来应该完成的动作。

如果说大多数运动都可以认为是基础动作模式的升级与排列组合，同时基础动作模式本身又能衍生出来很多训练动作，那么选择和实际运动相对应的练习就是另一个功能性的体现了。

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg25l7ep2j30g609o0ue.jpg)

比如说发展起跳能力，因为跳是蹲的升级，所以我一定首选深蹲练习；再比如说跑步，存在大量的下肢摆动与支撑的交替，摆动可以认为是下肢开链屈髋与蹬伸，而支撑可以认为是下肢单腿蹲的一瞬间，那么我会选择箱式单腿蹲，保加利亚蹲，悬垂屈髋等等；再再比如，拳击是基于“旋转”加“上肢推”加“单腿蹲”的动作模式，那么我就要练习剪蹲...旋转...单臂...推举...吗？

其实动作模式的选择要结合动力链一起去思考，这里除了要思考开链还是闭链之外，还要考虑动力链的完整性以及发力的顺序或者说是力学结构。说到上肢推的动作模式，水平推的话我相信很多人都会想到卧推和俯卧撑，那么这两个动作的功能性如何评价呢？

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg26a2ve0j30go0ce76n.jpg)

**卧推**，一个挺奇葩的动作，奇葩在哪呢？来，咱们数数卧推的主动关节都有哪些：肩关节，肘关节。那么我们上肢链在上肢推动作模式下参与的关节都有哪些呢？肩关节，肘关节！就这些么？再想想！其实你还疏漏了一个非常重要的关节——**肩胛胸关节**！几乎所有上肢的动作都以肩胛胸关节的运动为基础，而卧推却并没有，特别是标准的卧推~

![](https://ws4.sinaimg.cn/large/006tKfTcgy1fhg26h6oejj30go09lwgj.jpg)

**俯卧撑**，虽然肩胛胸，肩关节，肘关节全面参与到运动中去，但不巧的是它是一个闭链运动，而实际运动中我们的上肢会以开链为主！呵呵~

别着急，认真你就输了！上面两段其实是个伪命题，我这么做主要是想通过这个平易近人的例子来帮助大家掌握的分析问题的思路！如果你需要发展上肢最大力量表现，那么显然卧推是你的首选。而如果你要优化上肢的力学结构，特别是水平推的发力顺序，那么俯卧撑是你首选。再如果你要提高上肢的延展性以及伴随旋转的加速能力，那么单臂水平推的练习给你的帮助最大！

所以，选择什么，看目标喽~

#### 3. 专项需求

其实这个非常好理解，也是功能性原则的根本目的，但是为了和上面两个方向区分开，这里主要针对的是不同的运动素质需求。

Q：对一个英超的后卫进行长距离高强度的游泳练习是否具备功能性意义？！

A：具备！

Q：为什么？

A：因为他喜欢游泳，这个可以让他心情愉悦然后更好的训练和比赛！

咳咳！当然，这样的答案是合情合理的！但是我们不妨换一个角度去分析。

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg26rdi6vj30go0b4goo.jpg)

英超，几乎是足球联赛中对抗最强的，他们的后卫每场比赛动不动就跑个8千1万的，而这8千1万真心不是慢慢悠悠颠儿下来的，而是各种加速减速变向拼抢，所以其强度非常之大。那么这就需要很好的心肺系统功能，一方面体现在有氧与无氧耐力上，另一方面呼吸器官的机能上。游泳练习，不仅可以提高有氧以及无氧耐力，其水环境还可以给胸扩张带来阻力，直接锻炼了呼吸肌的收缩能力。另外，水环境真的能够给人们带来愉悦的感觉，特别是水流水压给肌肉和筋膜的按摩效果，真的是一举两得的“功能性”训练。

还有，你以为篮球运动员的拳击练习真的只是给枯燥乏味的体能训练增加一点乐趣么？并不是！

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg276m81pj31h50rgtbv.jpg)

**1. 拳击可以在发生场内冲突的时候很好地保护自己；**

**2. 拳击运动可以强化旋转动作模式下的速度、稳定、和准确性；**

**3. 拳击是手脚高度协调的运动，对于发展手脚搭配的动作灵敏有神奇的效果。**

而这些不就是一名篮球运动员所需要的么？！

## 总结

所以，功能性原则，解决的是“**为什么练**（for！not why）以及 **练什么**”的问题！

如果我们是简单活动活动身体那就算了，但如果我们要进行一个有针对性的体能训练，那么请琢磨琢磨你选择的动作是否合理，是否能够满足你的专项需求！

所以，招财猫式弹力带抗阻外旋真的是练习肩袖首推的动作么？

所以，蚌式练习和dirty dog真的是发展髋外旋外展能力最好的练习么？

![](https://ws2.sinaimg.cn/large/006tKfTcgy1fhg28jvnhqj30dw099q3z.jpg)

所以，仰卧卷腹发展出来的腹直肌是好看呢？还是好用呢？

所以，我们真的要来一次大清洗，摒弃掉我们以前那些练习么？

当然不要！每一个动作都有它存在的意义，都有它的价值所在！有可能这个动作和你要发展的能力不直接相关，但是它可能是你进行“功能性”训练的基础，你不得不去做它！

所以，训练的逻辑很重要！

>转自[《体能训练之功能性》](https://zhuanlan.zhihu.com/p/20786373)