---
layout:     post
title:      5分钟带你看完 WWDC 2018
subtitle:   WWDC 2018 Keynote 全记录
date:       2018-06-05
author:     BY
header-img: img/post-bg-cook.jpg
catalog: true
tags:
    - iOS
---

## 前言

一年一度的 WWDC（苹果全球开发者大会）于北京时间 6月5日 凌晨1点开幕。废话不多说，来看看这次WWDC 都有哪些亮点吧!


## iOS 12 和 ARKit 2.0

>关键词：官方防沉迷最为致命

### iOS 12 

iOS 12 相较于 iOS 11 并没有太多UI上的变动，刚更新完 bate 版本的 iOS 12，完全感觉不到这是个新系统。

iOS 12 主要是对安全和性能的优化，iOS 12 在旧设备上的运行速度比 iOS 11更块，程序加载速度快了一倍。（PS：看来苹果并没有放弃旧设备）

![](https://cdn.mos.cms.futurecdn.net/RdxhPVv8fAyM6oHsRgF6dH-650-80.png)

### ARKit 2.0 

Apple 与 皮克斯 合作开发了一种用于共享AR内容的新文件格式，新的 AR 格式名为 USDZ。

作为一个含着金苹果出生的新生儿，USDZ 一开始就得到了 Adobe Creative Cloud （包括 Photoshop CC、InDesign CC、Illustrator CC、Dreamweaver CC、Premiere Pro CC）套件的支持。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-10.jpg)

同时，面向开发者的开发套件 ARKit 则升级到了二代，主要提升了面部跟踪、渲染能力、3D 探测和共享体验等能力。

随后展示了一款名为 Measure 的 App，可使用AR查看物品大小。

![](https://cdn.mos.cms.futurecdn.net/4tbGCxGUGsH9VwSLsfMDK5-650-80.png)

最后为了演示新的 AR 能力和效果，苹果请来了乐高的创意总监来捧场。这是一个真实的乐高积木建筑物为基础，最多四个人可以用苹果 AR 应用进行游戏，可以在真实环境中模拟出各种虚拟的形象和建筑。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-9.jpg)
![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-11.jpg)

### 相册优化

iOS 12 的相册将大大提升搜索性能，系统不仅会提出搜索建议，还会帮你按主题整理照片。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-13.jpg)

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-14.jpg)

### Siri变得更聪明

iOS 12 中，苹果为 Siri 提供了更加高效的操作，让它可以操作各个应用内部的功能，并且能在锁屏界面建议用户下一步的行动。

苹果还发布了一款名为「Shortcuts」的应用，它允许用户自定义 Siri 搜索指令，支持通过拖拽来快速编辑指令，同时还提供了一个指令库供用户下载现成的命令，就像是为 Siri 打造的 Workflow 自动化工具。

![](https://cdn.sspai.com/2018-06-04-Artboard.jpg?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

看到这里，相比熟悉苹果的朋友大概明白了，Siri 的本次改进，很可能是源于它收购的效率神器 Workflow，堪称一个用 Siri 唤醒的 Workflow。

### 原生应用大更新

iOS 12 中，不少原生应用都得到了更新。

- iBooks 更名为 **Apple Books**，采用类似 App Store 的新界面设计。
- 新闻应用（News）在 iPad 上新添加了侧边栏，方便浏览，也突出策划内容。
- 语音备忘录现在支持 iCloud 了
- 股市的界面重构，可以看到股票全天走势，并打通 News 应用，方便看财经新闻；

### CarPlay 开放了

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-21.jpg)

CarPlay 变得更加开放了，曾经被苹果狠心抛弃的 Google Maps 和 Google 的干儿子地图 Waze，以及来自东方的神秘力量高德地图成为首批 CarPlay 支持的第三方导航，从此“志玲姐姐为您导航”将可以常伴林肯领航者车主左右，中国梦和美国梦一起实现。

### 防手机沉迷 - 划重点！

本次 iOS 12 的重点就是：**防沉迷！**

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-25.jpg)

鉴于手机上瘾成为了一个社会议题，今年 Google 和苹果都不约而同地将“防沉迷”加入到了系统更新当中：

- **Do Not Disturb（别吵我）**功能将关掉手机的视觉通知，在夜深人静想起她或梦见她的时候，来了邮件也不会亮屏刺破夜的静谧和黑暗
- Deliver Quietly（安静通知）则是将消息推送静默化、不显示在锁屏，也不出声，也不会在 app 右上角标红
- **Grouped Notifications（分组通知**）可以将某一类型的通知归组，微信群聊消息不再有轰炸的感觉
- **Reports（应用报告）**可以用周报告的形式，告诉用户用什么应用最多，哪个应用通知最多，每天起床第一个打开的是什么应用等等
- **App Limits（应用限制**）可以给某个应用规定使用时间，当然这不是强制性的，用户可以突破限制继续“吃鸡”
- **Allowances（零用钱？）** 是家长限制孩子使用应用的新特性

### iMessage 和 FeacTime

Animoji 新增了 4 个新表情（幽灵，考拉，老虎和霸王龙），用户还可以为自己量身定做 Animoji ，并用到各种场景——这就是全新的 Memoji 技术

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-26.jpg)

![](https://cdn.sspai.com/2018/06/05/67b6fba3d36bdd7caf09bec94dcb157b.jpg?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

iOS 版 **FaceTime** 迎来了群聊功能，最多支持 32 人同时聊天，成员可以随时加入或离开聊天。聊天界面用瀑布流的形式呈现，正在说话的成员窗口会自动放大。macOS 版 FaceTime 同样也得到了更新。

![](https://cdn.sspai.com/2018-06-04-Screen%20Shot%202018-06-05%20at%202.00.58%20AM.png?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

## tvOS

> 关键词：优化试听体验

tvOS 今年的变化比较小，更新主要集中在了影视资源以及细节优化上。

Apple TV 4K 将支持杜比全景声和杜比视界，让你在家里也能获得电影院般的听觉体验。

![](https://cdn.sspai.com/2018-06-04-Screen%20Shot%202018-06-05%20at%202.26.21%20AM.png?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

## watchOS 5

> 关键词：运动进行到底

随着 Apple Watch 成长的，还有它的操作系统 watchOS，这一次 watchOS 升级到了第五代。


![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-31.jpg)

Apple Watch 的功能朝着运动的方向发展，此次 watchOS 5 的更新，也以运动为主。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-35.jpg)

watchOS 5 的一个小惊喜是让 Apple Watch 成为了对讲机，这个应用名为 Walkie Talkie（对讲机）。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-38.jpg)


Apple Watch 早就支持了 Apple Pay，不过在通知上，Apple Watch 显然可以做得更多，比如值机和给滴滴师傅付款评分，手表不再只是个通知器，也能做些轻交互。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-51.jpg)

还有 Apple Watch 可以浏览网页了~

## macOS Mojave

> 关键词：夜间模式、全新的App Store

![](https://cdn.sspai.com/2018-06-04-macOS01.png?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

对于大多数人来说，macOS 更新最大的悬念，是新系统叫什么名字。

答案是：**macOS Mojave**，Mojave 中译名是莫哈韦沙漠，位于在美国加利福尼亚西南，出于洛杉矶和拉斯维加斯之间。

在 Mojave 这版系统中，苹果加入了一套适应暗光环境下使用的夜间主题，并对 Mac App Store 的交互界面进行了重塑，整个系统的改变甚至连库克都称为是苹果的一次 “巨大的跨越”。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-89.jpg)

### 夜间模式 / 动态桌面

不少用户会在暗光环境下使用电脑，即便是将屏幕亮度调到最低，也难免会因为白底色为主的主题而感到刺眼。在这次更新中，macOS Mojave 新增加了一套暗色主题，不同于目前将菜单和程序栏调成暗色的选项，新系统上的是一套全局暗色主题，即便是在文件夹、应用里都是以黑色为主色呈现。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-63.jpg)

另外，系统可根据时间变化对桌面进行自动调整，日间使用时系统为正常主题；夜间使用时系统则自动切换至暗色模式主题。此时，台下的开发者们爆发出了一阵欢呼，大概是这个主题能够提升程序员朋友夜间加班的幸福感吧。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-63.jpg)

### 智能分类

macOS 会跟据文件类型和标签对桌面的文件进行自动分类整理，从此再也不用担心满桌面都是文件了。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-82.jpg)

![](https://cdn.sspai.com/2018-06-04-macOS04.png?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

### 快速查看升级

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-92.jpg)

访达在这次系统上的更新并不多，只是针对图片查看增添了 “图库视图” 功能。通过 “图库视图”，用户可更加便捷快速地浏览到访达文件夹内的图片内容，与此同时功能内部也内置了图片元数据显示窗，用户可以借助数据窗口了解到图片的相关详情，并且可对图片进行快速编辑操作。

### 截图/录屏操作 - 类似iOS

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-93.jpg)

此次 macOS Mojave 加入了 “系统级” 的截屏功能，用户也可以在截屏后对截屏图片进行简单的标记。不过实际上，目前不少社交软件其实都已经具备了截图 + 标记的相关功能，且在体验上也相当不错。

### 安全权限

当我们在 iOS 系统上打开刚下载的应用程序时，系统会弹出弹窗，提示是否允许程序访问用户信息和手机硬件。而这次苹果也将相关的安全控制策略从 iOS “搬” 到了 macOS 上，当用户打开某个网址或程序时，系统会弹出 “是否允许访问” 的弹窗以获得用户批准。这也可能是为了呼应最近越发严格的隐私政策。

### 在 macOS 上运行的几款 iOS 程序

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-84.jpg)

将 iOS 的应用程序搬到 macOS 上运行是不少玩家曾经有过的想法。此次苹果在新版的 macOS 系统上加入了 iOS 端的新闻、股市、家、语音备忘录四个程序，用户可以在桌面系统上通过这几款应用阅读新闻、控制家庭设备等等。

在发布会的最后，苹果否认了将对 iOS 和 macOS 进行合并的传闻，但考虑到 iOS 平台有非常庞大的应用数量，他们也希望其中的部分应用能来到 macOS。于是苹果在发布会上为大家提前预览了一个准备多年的项目，macOS 将可以使用 iOS 的 UIKit 框架进行开发，以降低开发多平台应用的成本。

![](https://cdn.sspai.com/2018-06-04-Screen%20Shot%202018-06-05%20at%203.08.05%20AM.png?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

比如这次 macOS Mojave 中新增的 4 款应用——News、股票、语音备忘录、家庭——均采用了这种新技术。

### 全新的 Mac App Store

![](https://cdn.sspai.com/2018-06-04-macOS09.jpg?imageView2/2/w/1120/q/90/interlace/1/ignore-error/1)

在 iOS 11 对 Mac App Store 进行了重新设计后，macOS Mojave 也迎来了全新设计的 Mac App Store。新版拥有与 iOS 上 App Store 类似的发现页，里面能看到每日编辑推荐和一些 App 的使用技巧。进入 App 页面后，你可以看到视频预览和与 iOS 类似的评分系统。为了方便用户评分，新版 macOS 还加入了和 iOS 一样的 App 内打分功能。此外，苹果还宣布包括 Office 365 和 Adobe Lightroom CC 在内的一批重量级 App 将在今年稍后登录 Mac App Store。

## 结语

是的，这次的 WWDC 只有软件，没有新的电子设备发布，没有新 iPad Pro、没有 iPhone SE2、没有带八代酷睿的新 MacBook，唯一能和“硬件”沾上边的就是一个新的彩虹表带。

![](https://images.ifanr.cn/wp-content/uploads/2018/06/WWDC-56.jpg)

时至今日，苹果生态已经日趋完善了，大概苹果的产品经理们也想不出什么石破天惊的功能让大家 wow 一声了，有的只是细节层面的改进。作为看客和用户，也只能接受这样的现实了。

对了，那个可以四个人一起玩的乐高积木和 AR 应用，倒是可以考虑买来玩一下，不要一边说没有新东西，一边又对新东西视而不见。

对于 iOS 开发者来说，macOS 将可以使用 iOS 的 UIKit 框架进行开发是一个值得关注的点。

### 参考

- [WWDC 2018 Keynote](https://developer.apple.com/videos/play/wwdc2018/101/)
- [Apple WWDC 2018: what's new? All the announcements from the keynote](https://www.techradar.com/news/apple-wwdc-2018-keynote)
- [iOS 加入「防沉迷」，macOS 有了暗色主题，今年的 WWDC 重点都在系统上](http://www.ifanr.com/1043270)
- [苹果 WWDC 2018：最全总结看这里，不错过任何重点](https://sspai.com/post/44816)
 

